<?php
 
include_once 'conexao.php';
  
class ModeloVagaFiliado  
{    
	static public function mdlAddVagaFiliado($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO vagafiliado 
						(idVaga,preco, idUsuario, dataCadastro,valorGanhoPorCadaVendaFiliado) VALUES 
						(:idVaga,:preco, :idUsuario, :dataCadastro,:valorGanhoPorCadaVendaFiliado)");
		
		$stmt->bindParam(":preco", $dados["preco"], PDO::PARAM_STR);
		$stmt->bindParam(":valorGanhoPorCadaVendaFiliado", $dados["valorGanhoPorCadaVendaFiliado"], PDO::PARAM_STR);
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
	
	static public function mdlMostrarTodasVagaFiliado() {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vagafiliado ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	} 

	static public function mdlMostrarVagaFiliadoPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vagafiliado where idVaga = :idVaga");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasDisponivel() {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idVaga > 0");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
  
	static public function mdlMostrarVagaPeloNomeDaVagaEPeloIdUsurario($vaga, $idRecrutador) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where vaga = :vaga and idRecrutador = :idRecrutador");
			$stmt->bindParam(":vaga", $vaga, PDO::PARAM_STR);
			$stmt->bindParam(":idRecrutador", $idRecrutador, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarMinhasVagasPorIdUsurario($idRecrutador) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idRecrutador = :idRecrutador");
			$stmt->bindParam(":idRecrutador", $idRecrutador, PDO::PARAM_STR);
			$stmt ->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasPorCategoriaDaVaga($tipoVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga");
			$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVagas() {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET precoCertificado = :precoCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":precoCertificado", $precoCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET idModeloCertificado = :idModeloCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idModeloCertificado", $idModeloCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>